﻿Public Class Form1
    Public device As MassduinoUsbHid.Device = Nothing

    ''' <summary>
    ''' Close the device currently opened
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub CloseDevice()
        If Not device Is Nothing Then
            'Remove the usb report string handler
            RemoveHandler device.reportString, AddressOf reportString

            Try
                'Invoke the close function
                device.Close()
            Catch ex As Exception
            End Try
        End If
    End Sub

    ''' <summary>
    ''' Open the device corresponding the serialNumber
    ''' </summary>
    ''' <param name="serialNumber"></param>
    ''' <remarks></remarks>
    Public Sub OpenDevices(ByVal serialNumber As String)
        'Close the device already opened
        CloseDevice()

        'Get the new open device
        device = New MassduinoUsbHid.Device(serialNumber)
        'Add the usb report string handler
        AddHandler device.reportString, AddressOf reportString
    End Sub


    Private Sub Form1_FormClosed(sender As Object, e As FormClosedEventArgs) Handles Me.FormClosed
        'Before the form1 closed, we must close the opened device
        CloseDevice()
    End Sub

    ''' <summary>
    ''' The report string handler function
    ''' It can add the recv string to textBox1
    ''' Because this function is called by other thread so here it need to used the invoke mechanism to avoid the exceptions happen
    ''' </summary>
    ''' <param name="SerialNumber"></param>
    ''' <param name="str"></param>
    ''' <remarks></remarks>
    Delegate Sub dlReportString(ByVal SerialNumber As String, ByRef str As String)
    Private Sub reportString(ByVal SerialNumber As String, ByRef str As String)
        'Firstly check whether the invoke required
        If textBox1.InvokeRequired = True Then
            'Do invoke here
            Dim pInvoke As New dlReportString(AddressOf reportString)
            Me.Invoke(pInvoke, {SerialNumber, str})
        Else
            'Do the exactly functions here
            Try
                'make sure the textBox1 contents less than 50 to speed up its speed
                If textBox1.Text.Length > 4096 Then
                    textBox1.Text = ""
                End If

                'Add the recv string to textbox1
                textBox1.Text &= str
            Catch ex As Exception
            End Try
        End If
    End Sub

    Private Sub bt_Clear_Click(sender As Object, e As EventArgs) Handles bt_Clear.Click
        textBox1.Text = ""
    End Sub

    Private Sub bt_Send_Click(sender As Object, e As EventArgs) Handles bt_Send.Click
        If txt_Input.Text.Length = 0 Then
            MsgBox("Input text cannot be empty!")
            Return
        End If

        If combo_DeviceList.SelectedIndex < 0 Then
            MsgBox("Please select a device!")
            Return
        End If

        'call the writeString function
        device.writeString(txt_Input.Text)
    End Sub

    Private Sub bt_Search_Click(sender As Object, e As EventArgs) Handles bt_Search.Click
        combo_DeviceList.Items.Clear()

        'New a list object to receive the sn list
        Dim deviceSnList As New ArrayList
        'Call the searchDevices to get all the devices currently exist on system
        MassduinoUsbHid.Device.searchDevices(deviceSnList)

        'Add all the searched device's sn to Device List one by one
        Dim index As Integer = 0
        For Each pItem As String In deviceSnList
            combo_DeviceList.Items.Add(pItem)
            index += 1
        Next
    End Sub

    Private Sub combo_DeviceList_SelectedIndexChanged(sender As Object, e As EventArgs) Handles combo_DeviceList.SelectedIndexChanged
        If combo_DeviceList.SelectedIndex < 0 Then
            Return
        End If

        'Here to open the device which selected, ready to receive any string from the usb
        OpenDevices(combo_DeviceList.Text)
    End Sub
End Class
